#version 110
#extension GL_EXT_gpu_shader4 : enable
//checkerboard animation 11Mod01.fsh  by DjinnKahn 

//https://www.shadertoy.com/view/WsdBWl
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform float     iTimeDelta;
#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926

float sqr( float x ) { return x*x; }

//void rayCastSphere( vec3 p, vec3 v, float radius, inout float dist, inout float color )
//{    
//	float S = sqr( dot( p, v ) ) - dot( p, p ) + sqr(radius);
//    if ( S < 0. ) return;
//    float t0 = -dot( p, v ) - sqrt( S );
//    float t1 = -dot( p, v ) + sqrt( S );
//    float t;
//    if ( t0 >= 0. && t0 < dist )
//        t = t0;
//    else if ( t1 >= 0. && t1 < dist )
//        t = t1;
//    else 
//        return;
//    
//    vec3 hitPt = p + v*t;
//    dist = t;
//    color = t*.4;
//}

float easeInOutQuad( float x ) 
{
	return x < 0.5 ? 2. * x * x : 1. - pow(-2. * x + 2., 2.) / 2.;
}

float ease01( float t )
{
    t = clamp( t, 0., 1. );
    return t*t*.5; // want slope=1 at t=1
}

const float END_TIME = 3.6;

float timelineRaw( float t )
{
    float ret = 0.;
    t = mod( t, END_TIME + .2 );
    
    const float EASE_IN_DURATION = .4;
    const float EASE_OUT_DURATION = .4;
    const float LINEAR_DURATION = END_TIME - EASE_IN_DURATION - EASE_OUT_DURATION;
    
    ret += ease01( t / EASE_IN_DURATION ) * EASE_IN_DURATION;
    t -= EASE_IN_DURATION;
    if ( t <= 0. ) return ret;
    
    ret += min( t, LINEAR_DURATION );
    t -= LINEAR_DURATION;
    if ( t <= 0. ) return ret;
    
    ret += ( ease01( 1. ) - ease01( 1. - t / EASE_OUT_DURATION ) ) * EASE_IN_DURATION;
    return ret;
}

float timeline( float t )
{
    return timelineRaw( t ) / timelineRaw( END_TIME ) * END_TIME;
}


vec3 rotY( vec3 p, float angle )
{
    return vec3( p.x * cos(angle) + p.z * sin(angle), p.y, p.x * -sin(angle) + p.z * cos(angle) );
}
vec3 rotX( vec3 p, float angle )
{
    return vec3( p.x, p.y * cos(angle) + p.z * sin(angle), p.y * -sin(angle) + p.z * cos(angle) );
}

float checker( vec2 p ) 
{    
    return fract( p.x ) >= .5 == fract( p.y ) > .5 ? 0. : 1.; 
}

float sdPlane( vec3 p, vec3 n, float h )
{
  return dot(p,n) + h;
}

float sdTorus( vec3 p, vec2 t )
{
    vec2 q = vec2(length(p.xy)-t.x,p.z);
    return length(q)-t.y;
}

const float CAMERA_Z = -3.;
const float FLOOR_POS = 3.5;
const float WALL_POS = FLOOR_POS;

float sdScene( vec3 p )
{
 	float sd = sdTorus( p, vec2( .8, .4 ) );
    sd = min( sd, sdPlane( p, vec3(0.,0.,-1.), FLOOR_POS ) );
    sd = min( sd, sdPlane( p, vec3(0.,-1.,0.), WALL_POS ) );
    sd = min( sd, sdPlane( p, vec3(0.,1.,0.), WALL_POS ) );
    sd = min( sd, sdPlane( p, vec3(0.,0.,1.), WALL_POS ) );
    return sd;
}


float projectChecker( vec3 p )
{
    vec3 cameraPos = vec3( 0, 0, CAMERA_Z );
    float t = ((CAMERA_Z-1.) - p.z) / (cameraPos.z - p.z);
    vec3 screenUV = p * (1.-t) + cameraPos * t;
    return checker( screenUV.xy * 4. );
}

float go( vec2 fragCoord, float t )
{
    vec2 uv = (fragCoord - iResolution.xy*.5) / iResolution.y;
    if ( uv.x < -.5 || uv.x >= .5 )
        return .2;
        
    //uv.xy += .5 / iResolution.y;
    
    float angle = t*2.*PI;
    
    vec3 pos = vec3( 0., 0., CAMERA_Z + sin( angle )*1.1 );
    vec3 dir = vec3( uv.xy, 1. );
    pos += dir * max(-1.2 - pos.z, 0.); // ignore walls that we move behind
    dir = normalize( dir );
    
    pos = rotY( pos, sin(angle)*.8 );
    dir = rotY( dir, sin(angle)*.8 );
    pos = rotX( pos, angle );
    dir = rotX( dir, angle );
    
           
    
    
    for ( int i = 0; i < 300; i++ )
    {
        float dist = sdScene( pos );
   		pos += dir * dist;
        if ( dist < .0001 )
        {
            const float EPS = .01;
            //return pos.y / 5.;
            float f = 4. / (FLOOR_POS-CAMERA_Z);
            if ( pos.y >= WALL_POS-EPS )
                return checker( pos.xz * f );
            if ( pos.y <= -(WALL_POS-EPS) )
                return checker( pos.xz * f );
            if ( pos.z <= -(WALL_POS-EPS) )
                return checker( pos.xy * f );
            return projectChecker( pos );
        }
    }
    
    return .4;
}

vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float c = go( fragCoord, timeline( iTime ) / END_TIME );
    
    int BLUR_N = 4;
    
    float colSum = 0.;
    for ( int i = 0; i < BLUR_N; i++ )
    {    
		colSum += go( fragCoord, ( timeline( iTime + iTimeDelta * float(i) / float(BLUR_N) ) ) / END_TIME ) / float(BLUR_N);
    }

    fragColor = vec4(vec3(colSum),1.0);
    //fragColor = vec4(vec3(c),1.0);
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.